/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.connect;

import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.ui.UIStyle;
import com.ibm.hwmca.fw.ui.UIStyleManager;
import com.ibm.hwmca.fw.util.Trace;

class ConnectClient {
    private static final String TRACE_MASKT = "XUCNUICT";
    Client client = null;
    private boolean failedToInitialize;

    ConnectClient() {
    }

    private synchronized boolean initialize() {
        if (this.failedToInitialize) {
            return true;
        }
        if (this.client != null) {
            return false;
        }
        try {
            this.client = new Client("com.ibm.hwmca.fw.servlet.connect.ConnectServer", null);
            this.client.init();
            return false;
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKT, "Received TaskletException initializing ConnectClient");
            Trace.trace(TRACE_MASKT, e);
            this.failedToInitialize = true;
            return true;
        }
    }

    public boolean isPasswordExpired(String user) {
        if (this.initialize()) {
            return false;
        }
        try {
            TaskletRequest request = new TaskletRequest();
            request.setData("operation", "isPasswordExpired");
            request.setData("userid", user);
            TaskletResponse response = this.client.request(request);
            boolean result = (Boolean)response.getData("pwexpired");
            Trace.trace(TRACE_MASKT, "Password for user \"" + user + "\" has " + (result ? "" : "not ") + "expired.");
            return result;
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKT, "Received TaskletException interrogating password expiration for user \"" + user + '\"');
            Trace.trace(TRACE_MASKT, e);
            return false;
        }
    }

    public UIStyle getUIStyleForUser(String user) {
        if (this.initialize()) {
            return ConnectClient.getDefaultUIStyle();
        }
        try {
            TaskletRequest request = new TaskletRequest();
            request.setData("operation", "getUsersUI");
            request.setData("userid", user);
            TaskletResponse response = this.client.request(request);
            UIStyle uiStyle = (UIStyle)response.getData("uistyle");
            if (uiStyle != null) {
                return uiStyle;
            }
            return ConnectClient.getDefaultUIStyle();
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKT, "Received TaskletException interrogating UI style for user \"" + user + '\"');
            Trace.trace(TRACE_MASKT, e);
            return ConnectClient.getDefaultUIStyle();
        }
    }

    private static UIStyle getDefaultUIStyle() {
        UIStyleManager uiManager = UIStyleManager.getUIStyleManager();
        return uiManager.getDefaultUIStyle();
    }

    public synchronized void dispose() {
        if (this.client != null) {
            this.client.terminate();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

